define([
    'underscore',
    'backbone',
    'marionette',
    'modules/form/section-view',
    'json!modules/community-care-request/new-appointment-request-question/preferred-provider/choices/choice.json', // eslint-disable-line max-len
], function(
    _,
    Backbone,
    Marionette,
    SectionView,
    metadata
) {
    'use strict';
    return SectionView.extend({
        initialize: function(options) {
            var sectionName = 'primary-provider';
            var deleteBtn;
            this.id = options.id;
            this.legend = this.getLegendFromMetadata(sectionName, metadata, false) + this.id || '';
            this.collection = this.getQuestionsFromMetadata(sectionName, metadata, options);
            this.wizardModel = options.model;
            this.model = this.wizardModel.get('preferredProviders').get(this.id);

            // this updates delete so it knows what provider to delete
            deleteBtn = this.collection.get('delete-provider');
            deleteBtn.set('id', this.id);
            deleteBtn.set('needsProviderId', true);

            this.initializeQuestionEventListeners();
            this.validator = options.validator;
        },
        ui: {
            add: '.add-provider > button',
            delete: '.delete-provider > button',
        },
        modelEvents: {
            'change:providerStreet': 'modifyProviderAddress',
            'change:providerState': 'modifyProviderAddress',
            'change:providerCity': 'modifyProviderAddress',
            'change:providerZipCode': 'modifyProviderAddress',
        },
        events: {
            'click @ui.add': 'addProvider',
            'click @ui.delete': 'deleteProvider',
            'touchend @ui.add': 'addProvider', // this is for mobile, didn't work without it
            'touchend @ui.delete': 'deleteProvider', // this is for mobile, didn't work without it
        },
        onRender: function() {
            var providerMax = 3;

            // assert that delete show be shown and add hidden
            this.showDeleteBtn();
            this.hideAddBtn();

            // delete is never shown for the first provider!
            if (this.id === 1) {
                this.hideDeleteBtn();
            }

            // when: the id is equal to the length (e.g. the last item in the group)
            // and: the id is less than the max of allowed providers
            // then: we show the add button
            if (this.id === this.wizardModel.get('preferredProviders').length && this.id < providerMax) {
                this.showAddBtn();
            }
        },
        addProvider: function() {
            var providerMax = 3;
            // we always hide the current add button when we add a new provider
            if (this.wizardModel.get('preferredProviders').length !== providerMax) {
                this.triggerMethod('provider:add');
            }
        },
        onProviderAdd: function() {
            this.hideAddBtn();
        },
        hideAddBtn: function() {
            this.$el.find('.add-provider > button').hide();
        },
        hideDeleteBtn: function() {
            this.$el.find('.delete-provider > button').hide();
        },
        showDeleteBtn: function() {
            this.$el.find('.delete-provider > button').show();
        },
        showAddBtn: function() {
            this.$el.find('.add-provider > button').show();
        },
        deleteProvider: function() {
            this.triggerMethod('provider:delete', this.id);
        },
        onProviderDelete: function(id) {
            this.showAddBtn();
        },
        modifyProviderAddress: function() {
            this.model.set('address', {
                street: this.model.get('providerStreet') || '',
                city: this.model.get('providerCity') || '',
                state: this.model.get('providerState') || '',
                zipCode: this.model.get('providerZipCode') || '',
            });
        },
    });
});
